/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	EnvironmentalSound
**
** DESCRIPTION:	Environmental sound
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ENVIRONMENTAL_SOUND_H
#define ENVIRONMENTAL_SOUND_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "Sound.h"
#include "../Villagers/VillagerAttachmentInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int EnvironmentalSound_c_iMaxSounds = 100;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ESoundType
{
	eSoundType_Looping,
	eSoundType_VariantLooping,
	eSoundType_OneShot,
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CEnvironmentalSound : public IVillagerAttachment
{
private:

	struct SSound
	{	
		bool			m_bExists;
		bool			m_bIsPlaying;
		unsigned int	m_uiLastPlayTime;
		ESound			m_eSound;
		int				m_iOwner;
		ESoundType		m_eSoundType;
		ldwPoint		m_sOrigin;
		float			m_fChanceOfPlaying;
		float			m_fVolume;
		int				m_iDelay;
	};

	//class data
	SSound				m_sSound[EnvironmentalSound_c_iMaxSounds];
	bool				m_bVariantsPaused;

	//class methods
	//setup
	public:		CEnvironmentalSound();
	public:		~CEnvironmentalSound();
	public:		void Reset();
	
	//process
	public:		const int AddSound(const ESound eSound, const int iOwner, const ESoundType eSoundType, const ldwPoint sOrigin, const float fChanceOfPlaying, const float fVolume = 1.0f);
	public:		void RemoveSound(const ESound eSound);
	public:		void Remove(const int iRef);

	public:		void Update();
	public:		void Draw();

	public:		void PauseVariantSounds();
	public:		void ResumeVariantSounds();
	public:		void StopSounds(const int iOwner = -1);

	public:		void SetPos(const int iRef, const ldwPoint sPos);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CEnvironmentalSound		EnvironmentalSound;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/